#ifndef __C_PBCASTLAYER_H
#define __C_PBCASTLAYER_H

#define WIN32_LEAN_AND_MEAN

#include "Endpoint/cEndpoint.h"
#include "Interfaces/cLayer.h"
#include "cPbcastLayerParam.h"
#include <winsock2.h>

class cRegisterList;
class cSubnetTree;
class cSortedMsgQueue;
class cPbcastNode;
class cProtocolStack;
class cPbcastView;
struct Header;

/*
 * cPbcastLayer.h
 *
 * Standard network layer.
 */
class cPbcastLayer : public cLayer, public cDeliver, public cErrorCallback
{

  public:

	/* --Deliver Methods-- */
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);

	/* --Error Callback Method-- */
	bool ErrorCallback(cObject* param, unsigned int type);

	// Init/Clean
	bool Init(cLayer* layerBelow, cParam* param);
	bool Cleanup();

	// Sending of messages.
	bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType);

	bool Schedule();

	// Callback Registration/Unregisteration
	bool		RegisterDeliverCallback(cHandle* handle, cDeliver* callback);
	bool		UnregisterDeliverCallback(cHandle handle);
	bool		RegisterViewCallback(cHandle* handle, cView* callback);
	bool		UnregisterViewCallback(cHandle handle);
	bool		RegisterErrorCallback(cHandle* handle, cErrorCallback* callback);
	bool		UnregisterErrorCallback(cHandle handle);

	// Extra method(s)
	PbcastParams*	ReportStats()	{ return &mParam; }

  private:
	bool _ComputeParams();
	double _Pinf(double k);
	double _K(double i);
	bool _ProbTest(int probVal);
	int	 _ComputeProb(double percent);
	bool _AttemptDelivery(cPbcastNode* node);
	bool _CheckForDeadNodes();
	bool _HandleRetrReq(cEndpoint* sender, Header* header, cMsgBuffer* msg);
	bool _HandleFullGossip(cEndpoint* sender, Header* header, cMsgBuffer* msg);
	bool _HandleMinGossip(cEndpoint* sender, Header* header, cMsgBuffer* msg);
	bool _HandleData(cEndpoint *sender, Header* header, cMsgBuffer* msg);
	bool _HandleDataDissemination(cEndpoint* sender, Header* header, cMsgBuffer* msg);
	bool _SetupParams(cPbcastLayerParam *param);
	void _FullGossip(bool request=false);	// Send full information about all nodes.
	void _MinGossip();	// Send digest of view plus info about nodes.
	bool _ViewChange();		// Delivers new view to those registered.
	bool _ChooseGossipGroup();
	bool _AddToRetransmitReqMsg(u_short viewIndex, cPbcastNode* localNode, cPbcastNode* remoteNode);
	bool _ResetRetransmitReqMsg();
	bool _DeliverErrorCallback(cObject* obj, unsigned int type);

	// pbcast parameters
	PbcastParams	mParam;

	// Members
	cHandle			mLayerBelowHandle;
	cHandle			mErrorCallbackHandle;
	cRegisterList*	mRegisterList;			// Registered delivers.
	cRegisterList*  mViewList;				// Registered viewers.
	cRegisterList*  mErrorCallbackList;		// Registered error callback viewers.
	cProtocolStack* mProtocolStack;
	cPbcastNode*	mMyNode;
	char			mMyEpSer[MAX_ENDPOINT_SIZE];
	bool			mStarted;
	unsigned int	mSeqNum;

	// Gossip
	DWORD			mNextGossip;

	// MSG QUEUE
	cSortedMsgQueue* mMsgQueue;

	// Groups
	cSubnetTree*	mSubnetTree;
	cGroup*			mGossipGroup;
	cGroup*			mSendGroup;

	// Retransmission
	char			mRetransmitBuffer[256];
	char*			mRetransmitPtr;
	int				mRetransmitBytesLeft;
	unsigned int	mNumRetranReq;
	cGroup*			mRetransReqGroup;
	unsigned int	mBytesRetransmittedInThisRound;
	unsigned int	mNumRetransReqInThisRound;

	cPbcastView*	mView;
	cPbcastView*	mFailedNodes;
};

#endif
